plugin Helper RAComponent 
	name:"RA2 Cmpnt"
	classID:#(0x71d481ff, 0xe6c6ab7a)
	extends:Dummy
	replaceUI:true
(

local lCategories = #("power", "extenders", "mechanics", "mobility", "weapons", "extras")
local lBases = #("Component", "AirTank", "Battery", "BurstMotor", "BurstPiston", "ControlBoard", "ServoMotor", "ServoPiston", "SpinMotor", "Weapon", "Wheel")

parameters fNames rollout:fileRollout
(
pBasepath type:#string ui:pathText default:"C:\\RA2Components\\"
pFilename type:#string ui:gmfText default:"component"
)

parameters mainParams rollout:main
(
pName type:#string ui:nameText
pCategory type:#integer ui:ddCategory default:1
pBase type:#integer ui:ddBase default:1
pDirectory type:#string ui:directoryText default:"directory"
pPreview type:#string ui:previewText
pMaster type:#node ui:masterBtn
pPassthru type:#node ui:passthruBtn
pAttaching type:#node ui:attachBtn
)

parameters descParams rollout:descRollout
(
pDescription type:#string ui:descText
)

parameters prismParams rollout:prismRollout
(
pPrismatic type:#boolean ui:prismCB
pBody type:#node ui:bodyBtn
pSlider type:#node ui:sliderBtn
pSlideVector type:#string ui:vectorText
pStartlimit type:#float ui:startSpin
pEndlimit type:#float ui:endSpin
)

parameters styleParams rollout:styleRollout
(
-- pUseStyles type:#boolean ui:useStylesCB
pStyles type:#stringtab tabSize:0 tabSizeVariable:true
)

rollout export "Export" width:162 height:88
(
	button exportBtn "Export!" pos:[49,53] width:66 height:27
	dropDownList selectionDD "Selection set to export:" pos:[13,6] width:136 height:40
	on export open  do
	(
		local i = 1
		local stringset = #()
		local thisstring
		while i <= selectionsets.count do
		(
			thisstring = filterstring (selectionsets[i] as string) ":"
			append stringset thisstring[2]
			i = i + 1		
		)
		if (selectionsets.count == 0) then stringset = #("No selectionsets")
		selectionDD.items = stringset
	)
	on exportBtn pressed do
	(
		local txtfileName, fStream, gmffileName
		local i = 1
		--build the subdirectory in case it doesn't exist
		makedir pBasepath
		makedir (pBasepath + pDirectory)
		makedir (pBasepath + "styles")
		while i <= pStyles.count do
		(
			--get the selection set
			if selectionsets.count == 0 do
			(
			messagebox "You must have a selection set created and chosen."
			exit
			)
			select selectionsets[selectionDD.selection]		
		
			-- export the text file
			if (i==1) then txtfileName= pBasepath + pFilename + (i as string) + ".txt"
			else txtfileName = pBasepath + "styles" + "\\" + pFilename + (i as string) + ".txt"
			fStream = createFile txtfileName
			format "name = %\n" pName to:fStream
			format "preview = %\n" pPreview to:fStream
			format "dir = %\n" pDirectory to:fStream
			format "model = %\n" (pFilename + (i as string) + ".gmf") to:fStream
			format "type = %\n" lCategories[pCategory] to:fStream
			format "base = %\n" lBases[pBase] to:fStream
			if pMaster != undefined do format "master = %\n" pMaster.name to:fStream
			if pPassthru != undefined do format "passthru = %\n" pPassthru.name to:fStream
			if pAttaching != undefined do format "attaching = %\n" pAttaching.name to:fStream
			if pPrismatic == true do format "prismatic = %, %, %, %, %\n" pBody.name pSlider.name pSlideVector pStartlimit pEndlimit to:fStream
			if i == 1 do
			(
				local stylelist = pStyles[1] --should always have the first item in the list as default style
				local z = 2
				while z <= pStyles.count do
				(
					stylelist = stylelist + ", "
					stylelist = stylelist + pFilename + (z as string) + ".txt"
					stylelist = stylelist + ", "
					stylelist = stylelist + pStyles[z]
					z = z + 1
				)
				format "styles = %\n" stylelist to:fStream	
			)
			format "description = %\n" pDescription to:fStream
			close fStream
			
			--export the GMF
			sliderTime = i-1
			gmffileName = pBasepath + pDirectory + "\\" + pFilename + (i as string) + ".gmf"
			Gabriel.ExportOps.export gmffileName (i-1) true
			
			i = i+1
		)
	sliderTime = 0
	)
)

rollout fileRollout "File Names" width:162 height:90 rolledup:true
(
	edittext pathText "" pos:[3,22] width:153 height:16
	button gmfFileBtn "Export Path:" pos:[7,3] width:70 height:16

	edittext gmfText "" pos:[3,59] width:153 height:16
	label lbl1 "Filename base (no ext):" pos:[9,45] width:135 height:12
)

rollout main "Main parameters" width:162 height:452
(
	edittext nameText "" pos:[4,16] width:150 height:16
	label lbl1 "Component Name:" pos:[8,2] width:106 height:14
	dropdownList ddCategory "Category" pos:[8,37] width:146 height:40 items:lCategories
	dropdownList ddBase "Base" pos:[7,80] width:148 height:40 items:lBases
--	dropdownList ddCategory "Category" pos:[8,37] width:146 height:40
--	dropdownList ddBase "Base" pos:[7,80] width:148 height:40

	
	edittext previewText "" pos:[4,182] width:146 height:16
	label lbl2 "Preview bitmap name:" pos:[8,165] width:106 height:14
	label lbl3 "Directory name:" pos:[8,125] width:106 height:14
	edittext directoryText "" pos:[4,142] width:146 height:17
	pickbutton passthruBtn "Pick" pos:[19,282] width:116 height:17
	label lbl4 "Passthru:" pos:[19,267] width:66 height:13
	GroupBox grp1 "Objects" pos:[7,205] width:145 height:162
	label lbl5 "Attaching:" pos:[19,303] width:66 height:13
	pickbutton attachBtn "Pick" pos:[19,319] width:116 height:17
	button resetBtn "Reset" pos:[21,346] width:48 height:14
	pickbutton masterBtn "Pick" pos:[18,243] width:116 height:17
	label lbl12 "Master:" pos:[18,227] width:66 height:13
	on main open do
	(
			if pPassthru != undefined do passthruBtn.caption = pPassthru.name
			if pAttaching != undefined do attachBtn.caption = pAttaching.name
			if pMaster != undefined do masterBtn.caption = pMaster.name
	)
	on ddCategory selected sel do
	(
		print sel
		if sel==4 then ddBase.selection = 11
		if sel==5 then ddBase.selection = 10
	)
	on passthruBtn picked obj do
	(
			pPassthru = obj
			passthruBtn.caption = obj.name
		)
	on attachBtn picked obj do
	(
			pAttaching = obj
			attachBtn.caption = obj.name
		)
	on resetBtn pressed do
	(
			pPassthru = undefined
			passthruBtn.caption = "Pick"
			
			pAttaching = undefined
			attachBtn.caption = "Pick"
		)
	on masterBtn picked obj do
	(
			pMaster = obj
			masterBtn.caption = obj.name
		)
)

rollout descRollout "Component Description" width:163 height:64 rolledup:true
(
	edittext descText "" pos:[5,6] width:150 height:50
)

rollout prismRollout "Prismatic Constraint" rolledup:true width:162 height:204
(
	pickbutton bodyBtn "Pick" pos:[17,45] width:125 height:16
	label lbl21 "Piston body:" pos:[19,31] width:65 height:12
	label lbl22 "Piston slider:" pos:[19,67] width:65 height:12
	pickbutton sliderBtn "Pick" pos:[17,82] width:125 height:16
	edittext vectorText "Slide vector:" pos:[13,107] width:134 height:19
	spinner startSpin "Start limit: " pos:[30,139] width:98 height:16 range:[-5,5,0]
	spinner endSpin "End limit: " pos:[33,165] width:95 height:16 range:[-5,5,0]
	checkbox prismCB "Export prismatic data" pos:[17,6] width:123 height:18
	on prismRollout open do
	(
			if pBody != undefined do bodyBtn.caption = pBody.name
			if pSlider != undefined do sliderBtn.caption = pSlider.name
		)
	on bodyBtn picked obj do
	(
			pBody = obj
			bodyBtn.caption = obj.name
	prismCB.checked = true
		)
	on sliderBtn picked obj do
	(
			pSlider = obj
			sliderBtn.caption = obj.name
	prismCB.checked = true
		)
)

rollout styleRollout "Styles" width:162 height:275 rolledup:true
(
	listbox styleLB "Style names:" pos:[13,7] width:133 height:10
	edittext newStyleText "" pos:[8,166] width:138 height:18
	button addBtn "Add" pos:[99,190] width:49 height:17
	button deleteBtn "Delete" pos:[12,191] width:49 height:16

	label lbl1 "Note: styles correspond to frame numbers (first style = frame 0; style n = frame n-1)" pos:[12,220] width:134 height:44
	on styleRollout open do
	(
		if pStyles.count==0 then append pStyles "Default"
		styleLB.items = #() + pStyles
	)
	on addBtn pressed do
	(
		if newStyleText.text != "" do
		(
			append pStyles newStyleText.text
			styleLB.items = #() + pStyles
			newStyleText.text = ""
		)
	)
	on deleteBtn pressed do
	(
		local i
		i = styleLB.selection
		if i != 0 do
		  (
		  deleteitem pStyles i
		  styleLB.items = #() + pStyles
		  )
	)
)

)